ScriptName RF:ShipTrackerScript Extends ReferenceAlias

RF:FuelHandlerQuest Property FuelManager Auto Mandatory Const
ActorValue Property SpaceshipGravJumpFuel auto const mandatory

Event OnShipFarTravel(Location aDepartureLocation, Location aArrivalLocation, int aState)
    FuelManager.HandleFarTravel(aDepartureLocation, aArrivalLocation, aState)
EndEvent

Event OnShipDock(bool abComplete, SpaceshipReference akDocking, SpaceshipReference akParent)
    FuelManager.HandleDocking(abComplete, akDocking, akParent)
EndEvent

Event OnShipUndock(bool abComplete, SpaceshipReference akUndocking, SpaceshipReference akParent)
    FuelManager.HandleUndocking(abComplete, akUndocking, akParent)
EndEvent

Event OnShipGravJump(Location aDestination, int aState)
    FuelManager.HandleGravJump(aDestination, aState)
EndEvent

Event OnShipRefueled(int aFuelAdded)
    FuelManager.HandleRefuel(aFuelAdded)
EndEvent

Event OnLocationChange(Location akOldLoc, Location akNewLoc)
    FuelManager.HandleLocChange(akOldLoc, akNewLoc)    
EndEvent

Event OnShipTakeOff(bool abComplete)
    FuelManager.HandleShipTakeOff(abComplete)
EndEvent